<?php
/*-----------------------------------------------------------------
* 	ID:						confirmVorkasse.php
* 	Letzter Stand:			v2.3
* 	zuletzt geaendert von:	cseoak
* 	Datum:					2012/11/19
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/

require_once('library/sofortLib.php');
chdir('../..');
include ('includes/application_top.php');
require_once(DIR_FS_CATALOG.'callback/sofort/helperFunctions.php');

if($_SESSION['language'] == 'english') {
	include(DIR_WS_LANGUAGES.'english/modules/payment/sofort_sofortvorkasse.php');
} else {
	include(DIR_WS_LANGUAGES.'german/modules/payment/sofort_sofortvorkasse.php');
}

// create smarty elements
$smarty = new Smarty;
// include boxes
require (DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/source/boxes.php');

// if the customer is not logged on, redirect them to the shopping cart page
if (!isset ($_SESSION['customer_id'])) {
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

$breadcrumb->add(NAVBAR_TITLE_1_CHECKOUT_CONFIRMATION);
$breadcrumb->add(NAVBAR_TITLE_2_CHECKOUT_CONFIRMATION);
require (DIR_WS_INCLUDES.'header.php');

if(empty($_SESSION['sofort_transaction'])) {
	//xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL'));
	//exit();
}

$smarty->assign('FORM_ACTION', xtc_draw_form('order', xtc_href_link(FILENAME_CHECKOUT_SUCCESS, 'all_inserted=1', 'SSL')));
$smarty->assign('BUTTON_CONTINUE', xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
$smarty->assign('BUTTON_PRINT', '<img src="'.'templates/'.CURRENT_TEMPLATE.'/buttons/'.$_SESSION['language'].'/button_print.gif" style="cursor:hand"
				onclick="window.open(\''.xtc_href_link(FILENAME_PRINT_ORDER, 'oID='.$orders['orders_id']).'\', \'popup\', \'toolbar=0, width=640, height=600\')" />');
$smarty->assign('FORM_END', '</form>');
$smarty->assign('HEADING', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_HEADING_TEXT);
$smarty->assign('TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_TEXT);
$smarty->assign('HOLDER', helperFunctions::htmlMask($_GET['holder']));
$smarty->assign('HOLDER_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_HOLDER_TEXT);
$smarty->assign('ACCOUNT_NUMBER', helperFunctions::htmlMask($_GET['account_number']));
$smarty->assign('ACCOUNT_NUMBER_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_ACCOUNT_NUMBER_TEXT);
$smarty->assign('IBAN', helperFunctions::htmlMask($_GET['iban']));
$smarty->assign('IBAN_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_IBAN_TEXT);
$smarty->assign('BANK_CODE', helperFunctions::htmlMask($_GET['bank_code']));
$smarty->assign('BANK_CODE_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_BANK_CODE_TEXT);
$smarty->assign('BIC', helperFunctions::htmlMask($_GET['bic']));
$smarty->assign('BIC_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_BIC_TEXT);
$smarty->assign('AMOUNT', helperFunctions::htmlMask($_GET['amount']). ' EUR');
$smarty->assign('AMOUNT_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_AMOUNT_TEXT);
$smarty->assign('REASON_1', helperFunctions::htmlMask($_GET['reason_1']));
$smarty->assign('REASON_1_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_REASON_1_TEXT);
$smarty->assign('REASON_2', helperFunctions::htmlMask($_GET['reason_2']));
$smarty->assign('REASON_2_TEXT', MODULE_PAYMENT_SOFORT_SV_CHECKOUT_REASON_2_TEXT);

// Google Conversion tracking
if (GOOGLE_CONVERSION == 'true') {
	$smarty->assign('google_tracking', 'false');
	$smarty->assign('tracking_code', '');
}

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('PAYMENT_BLOCK', $payment_block);
$smarty->caching = 0;
$main_content = $smarty->fetch('../callback/sofort/checkout_vorkasse.html');
//$main_content = '';
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content', $main_content);
$smarty->caching = 0;

// whats that?
if (!defined(RM)) {
	$smarty->load_filter('output', 'note');
}

$smarty->display(CURRENT_TEMPLATE.'/index.html');
include ('includes/application_bottom.php');
unset($_SESSION['sofort_transaction']);

?>